def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Assume we have objects named 'object_1' and 'object_2' that need to be manipulated
        object_1_pos = positions['object_1']
        object_2_pos = positions['object_2']

        # === Example Task Plan ===
        
        # Step 1: Move to the location of object_1
        print("[Task] Moving to object_1 at:", object_1_pos)
        obs, reward, done = move(env, 'initial_location', object_1_pos)
        if done:
            print("[Task] Task ended after moving to object_1!")
            return
        
        # Step 2: Pick up object_1
        print("[Task] Picking up object_1.")
        obs, reward, done = pick(env, 'object_1', object_1_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking up object_1!")
            return
        
        # Step 3: Move to a designated place to drop object_1
        print("[Task] Moving to drop location.")
        obs, reward, done = move(env, object_1_pos, 'drop_location')
        if done:
            print("[Task] Task ended after moving to drop location!")
            return
        
        # Step 4: Place object_1
        print("[Task] Placing object_1.")
        obs, reward, done = place(env, 'object_1', 'drop_location')
        if done:
            print("[Task] Task ended after placing object_1!")
            return
        
        # Step 5: Move to the location of object_2
        print("[Task] Moving to object_2 at:", object_2_pos)
        obs, reward, done = move(env, 'drop_location', object_2_pos)
        if done:
            print("[Task] Task ended after moving to object_2!")
            return
        
        # Step 6: Pick up object_2
        print("[Task] Picking up object_2.")
        obs, reward, done = pick(env, 'object_2', object_2_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking up object_2!")
            return
        
        # Step 7: Move to another designated place to drop object_2
        print("[Task] Moving to drop location for object_2.")
        obs, reward, done = move(env, object_2_pos, 'final_drop_location')
        if done:
            print("[Task] Task ended after moving to final drop location!")
            return
        
        # Step 8: Place object_2
        print("[Task] Placing object_2.")
        obs, reward, done = place(env, 'object_2', 'final_drop_location')
        if done:
            print("[Task] Task ended after placing object_2!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()