def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Object positions based on the retrieved data
        tomato_pos = positions['tomato']
        disposal_pos = positions['disposal']
        gripper = 'gripper'  # assuming we have a gripper identifier
        
        # Step 1: Approach and pick the tomato
        print("[Task] Approach and pick the tomato at:", tomato_pos)
        obs, reward, done = move(env, task, obs.robot_at, tomato_pos)
        if done:
            return
            
        obs, reward, done = pick(env, 'tomato', tomato_pos, gripper)
        if done:
            return
        
        # Step 2: Place the tomato at the disposal location
        print("[Task] Place the tomato at disposal location:", disposal_pos)
        obs, reward, done = place(env, 'tomato', disposal_pos)
        if done:
            return

        print("[Task] Task completed successfully!")

    except Exception as e:
        print(f"[Task] An error occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()