def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming the drawer is at 'drawer_position'
        drawer_position = positions['drawer']  # Update to actual drawer position
        robot_position = positions['robot']  # Assuming we have the robot position
        gripper = 'gripper'  # This should refer to your actual gripper object
        
        # Step 1: Move to the drawer's position
        print("[Task] Moving to the drawer position:", drawer_position)
        obs, reward, done = move(env, robot_position, drawer_position)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return
        
        # Step 2: Identify and open the drawer
        print("[Task] Opening the drawer.")
        obs, reward, done = pull(env, gripper, drawer_position)
        if done:
            print("[Task] Task ended after pulling on the drawer!")
            return
        
        # Step 3: At this point, we can pick up the item from the drawer
        item_position = positions['item']  # Update to actual item position in the drawer
        print("[Task] Picking the item at:", item_position)
        obs, reward, done = pick(env, 'item', item_position, gripper)
        if done:
            print("[Task] Task ended after picking the item!")
            return
        
        # Step 4: Move to the place location for the item
        place_location = positions['place_location']  # Update to actual place location
        print("[Task] Moving to place location:", place_location)
        obs, reward, done = move(env, drawer_position, place_location)
        if done:
            print("[Task] Task ended after moving to place location!")
            return
        
        # Step 5: Place the item
        print("[Task] Placing the item at:", place_location)
        obs, reward, done = place(env, 'item', place_location)
        if done:
            print("[Task] Task ended after placing the item!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()