def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example initial positions (you should replace these with actual identifiers)
        gripper_pos = positions['gripper']
        drawer_pos = positions['drawer']
        
        # Example Plan
        # 1. Move to the drawer to identify and check if it's locked
        print("[Task] Moving to drawer at:", drawer_pos)
        obs, reward, done = move(env, 'initial_room', drawer_pos)
        if done:
            return

        # 2. Check if the drawer is locked
        if not is_locked(drawer_pos):  # Assuming you have a function to check locking
            print("[Task] Drawer is not locked, proceeding to pull")
            
            # 3. Pull the drawer
            print("[Task] Pulling the drawer")
            obs, reward, done = pull(env, task, pull_distance=0.1)
            if done:
                print("[Task] Task ended after pulling the drawer!")
                return

        else:
            print("[Task] Drawer is locked. Taking further actions...")

            # Handle the locked drawer case, e.g., drawing actions to lock/unlock
            # You could implement additional checking and mechanism here

        # 4. Complete the task by placing objects or taking actions needed
        # (You should replace 'handle_final_task' with the actual actions required)
        print("[Task] Finalizing the task actions")
        obs, reward, done = place(env, obj_to_place, final_location)
        if done:
            print("[Task] Task ended after final actions!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()