def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve Object Positions
        positions = get_object_positions()

        # Define positions for the objects and robot
        obj_pos = positions['tomato']  # Change to your object's key
        robot_start_pos = positions['robot_start']  # Change to your robot start key
        drawer_pos = positions['drawer']  # Change to your drawer's key

        # Step 1: Move to the starting position
        print("[Task] Moving to starting position.")
        obs, reward, done = move(env, task, robot_start_pos, robot_start_pos)
        
        if done:
            print("[Task] Task ended after moving to start position!")
            return
        
        # Step 2: Move to the object (tomato)
        print("[Task] Moving to the tomato.")
        obs, reward, done = move(env, task, robot_start_pos, obj_pos)
        
        if done:
            print("[Task] Task ended after moving to tomato!")
            return
        
        # Step 3: Pick the object (tomato)
        print("[Task] Picking up the tomato.")
        obs, reward, done = pick(env, 'tomato', obj_pos, 'gripper')  # Assume 'gripper' is the name of the gripper
        
        if done:
            print("[Task] Task ended after picking the tomato!")
            return
        
        # Step 4: Move to the drawer
        print("[Task] Moving to the drawer.")
        obs, reward, done = move(env, task, obj_pos, drawer_pos)
        
        if done:
            print("[Task] Task ended after moving to drawer!")
            return
        
        # Step 5: Open the drawer
        print("[Task] Opening the drawer.")
        obs, reward, done = pull(env, 'gripper', 'drawer')  # Assuming 'drawer' is the name of the drawer
        
        if done:
            print("[Task] Task ended after opening the drawer!")
            return
        
        # Step 6: Place the object (tomato) into the drawer
        print("[Task] Placing the tomato inside the drawer.")
        obs, reward, done = place(env, 'tomato', drawer_pos)
        
        if done:
            print("[Task] Task ended after placing the tomato!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()