def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Extract the positions of the objects you are going to manipulate
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        rubbish_pos = positions['rubbish']

        # === Oracle Plan Execution ===
        # Step 1: Move to the position of tomato1
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, 'current_location', 'tomato1_location')
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return
            
        # Step 2: Pick up tomato1
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, 'tomato1', 'tomato1_location', 'gripper')
        if done:
            print("[Task] Task ended after picking up tomato1!")
            return
            
        # Step 3: Move to the position of tomato2
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, 'tomato1_location', 'tomato2_location')
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return
            
        # Step 4: Pick up tomato2
        print("[Task] Picking up tomato2.")
        obs, reward, done = pick(env, 'tomato2', 'tomato2_location', 'gripper')
        if done:
            print("[Task] Task ended after picking up tomato2!")
            return
            
        # Step 5: Move to the rubbish location
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, 'tomato2_location', 'rubbish_location')
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return
            
        # Step 6: Place rubbish
        print("[Task] Placing rubbish.")
        obs, reward, done = place(env, 'rubbish', 'rubbish_location')
        if done:
            print("[Task] Task ended after placing rubbish!")
            return
            
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()