def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer to manipulate
        gripper = 'gripper1'
        drawer = 'drawer1'
        object_pos = positions[drawer]  # Position of the drawer
        
        # Step 1: Move to the drawer's position
        print("[Task] Moving to the drawer location.")
        obs, reward, done = move(env, 'room1', object_pos)
        if done:
            print("[Task] Task ended while moving to the drawer!")
            return
            
        # Step 2: Use the gripper to pick the drawer handle
        print("[Task] Picking the drawer handle.")
        obs, reward, done = pick(env, drawer, object_pos, gripper)
        if done:
            print("[Task] Task ended while picking the drawer!")
            return

        # Step 3: Pull the drawer open
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, task, pull_distance=0.2, pull_axis='x', max_steps=100)
        if done:
            print("[Task] Task ended while pulling the drawer!")
            return

        # Step 4: Place items back at the initial position or perform further manipulations
        # Assume some items are placed back to the initial state/picked
        print("[Task] Placing items back in the drawer.")
        obs, reward, done = place(env, drawer, 'room1')  # Specify the room or area as needed
        if done:
            print("[Task] Task ended while placing items!")
            return

    except Exception as e:
        print(f"[Error] An error occurred: {e}")
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()