def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the positions dictionary contains already identified objects
        # Example object references
        tomato_pos = positions['tomato1']
        drawer_pos = positions['drawer']
        gripper = "gripper1"  # Presumed gripper identifier
        initial_angle = "zero_deg"  # Initial orientation state, adjust accordingly

        # Step 1: Move to the tomato
        print("[Task] Moving to tomato at:", tomato_pos)
        obs, reward, done = move(env, gripper, obs.robot_pose, tomato_pos)
        if done:
            print("[Task] Task ended after moving to tomato!")
            return

        # Step 2: Pick the tomato
        print("[Task] Picking up the tomato.")
        obs, reward, done = pick(env, 'tomato1', obs.robot_pose, gripper)
        if done:
            print("[Task] Task ended after picking the tomato!")
            return

        # Step 3: Move to the drawer
        print("[Task] Moving to drawer at:", drawer_pos)
        obs, reward, done = move(env, gripper, obs.robot_pose, drawer_pos)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        # Step 4: Place the tomato in the drawer
        print("[Task] Placing the tomato in the drawer.")
        obs, reward, done = place(env, 'tomato1', drawer_pos)
        if done:
            print("[Task] Task ended after placing the tomato!")
            return

        # Step 5: Rotate the gripper to adjust its angle (optional)
        print("[Task] Rotating gripper to adjust angle.")
        obs, reward, done = rotate(env, gripper, initial_angle, "ninety_deg")
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return

        # Optional: Pull a drawer (if necessary)
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, task, 0.15)  # Adjust parameters as necessary
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()