def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming the robot needs to pick an object securely placed on a table
        table_pos = positions['table']
        object_1_pos = positions['object_1']  # Adapting for object variables
        object_2_pos = positions['object_2'] 

        # Step 1: Move to the table
        print("[Task] Moving to the table at:", table_pos)
        obs, reward, done = move(env, task, from_room="starting_area", to_room="table_room")
        if done: return

        # Step 2: Pick the first object
        print("[Task] Picking object 1 at:", object_1_pos)
        obs, reward, done = pick(env, "object_1", "table_room", "gripper")
        if done: return

        # Step 3: Move to a designated location for placing object 1
        print("[Task] Moving to the placing area.")
        obs, reward, done = move(env, task, from_room="table_room", to_room="placing_area")
        if done: return

        # Step 4: Place the first object
        print("[Task] Placing object 1.")
        obs, reward, done = place(env, "object_1", "placing_area")
        if done: return
        
        # Step 5: Move back to the table
        print("[Task] Returning to the table.")
        obs, reward, done = move(env, task, from_room="placing_area", to_room="table_room")
        if done: return

        # Step 6: Pick the second object
        print("[Task] Picking object 2 at:", object_2_pos)
        obs, reward, done = pick(env, "object_2", "table_room", "gripper")
        if done: return

        # Step 7: Move to a designated location for placing object 2
        print("[Task] Moving to the placing area.")
        obs, reward, done = move(env, task, from_room="table_room", to_room="placing_area")
        if done: return
        
        # Step 8: Place the second object
        print("[Task] Placing object 2.")
        obs, reward, done = place(env, "object_2", "placing_area")
        if done: return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()