def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Example object positions (these should be replaced with actual object names)
        gripper_position = positions['gripper']
        drawer_position = positions['drawer']
        object_position = positions['object']  # This should match the object you're manipulating

        # Plan execution assuming gripper and drawer have been defined
        try:
            # Move to drawer position
            print("[Task] Moving to drawer position:", drawer_position)
            obs, reward, done = move(env, gripper_position, drawer_position)
            if done:
                print("[Task] Task ended after moving to drawer position!")
                return

            # Pick drawer handle
            print("[Task] Picking drawer.")
            obs, reward, done = pick(env, 'drawer_handle', drawer_position, 'gripper')
            if done:
                print("[Task] Task ended after picking drawer!")
                return
                
            # Pull the drawer open
            print("[Task] Pulling the drawer.")
            obs, reward, done = pull(env, task, pull_distance=0.1)  # Note: Adjust pull distance as necessary
            if done:
                print("[Task] Task ended after pulling the drawer!")
                return
            
            # Place the object somewhere (assuming you have a specific location)
            print("[Task] Placing object at:", object_position)
            obs, reward, done = place(env, 'object', object_position)
            if done:
                print("[Task] Task ended after placing the object!")
                return
            
        except Exception as e:
            print(f"[Error] An exception occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()