def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assumed object names from the PDDL aspects
        gripper = 'gripper'
        drawer = 'drawer1'
        target_object = 'object'  # Substitute with actual object names from the position dictionary

        # Fetch positions for the tasks
        object_pos = positions.get(target_object)
        print(f"[Task] Moving to position of {target_object} at:", object_pos)

        # Move to the object's location
        obs, reward, done = move(env, task, 'initial_position', object_pos)
        if done:
            print("[Task] Task ended after moving to the object's location!")
            return

        # Pick the object
        print(f"[Task] Picking up {target_object}...")
        obs, reward, done = pick(env, task, target_object, object_pos, gripper)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Move to the drawer's side position
        print(f"[Task] Moving to the side of {drawer}...")
        side_pos = positions.get('side_position')  # Substitute with actual side position
        obs, reward, done = move(env, task, object_pos, side_pos)
        if done:
            print("[Task] Task ended after moving to the side position!")
            return

        # Pick the drawer
        print(f"[Task] Picking the drawer {drawer}...")
        obs, reward, done = pick(env, task, drawer, side_pos, gripper)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Pull open the drawer
        print(f"[Task] Pulling the drawer {drawer} open...")
        obs, reward, done = pull(env, task, drawer)
        if done:
            print("[Task] Task ended after opening the drawer!")
            return

        # Finally, place the object into the drawer
        print(f"[Task] Placing {target_object} into the {drawer}...")
        obs, reward, done = place(env, task, target_object, drawer)
        if done:
            print("[Task] Task completed successfully!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()