def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the gripper and drawer are among the objects
        # Modifying the object list as per feedback
        gripper = 'gripper'
        drawer = 'drawer'
        gripper_pos = positions[gripper]
        drawer_pos = positions[drawer]

        # 1. Rotate the gripper to the target angle
        target_quat = [0, 0, 0, 1]  # Adjust as necessary for your application
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Rotation completed.")
            return

        # 2. Move to the drawer
        print("[Task] Moving to the drawer.")
        obs, reward, done = move(env, gripper, gripper_pos, drawer_pos)
        if done:
            print("[Task] Moved to the drawer.")
            return

        # 3. Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, drawer, drawer_pos, gripper)
        if done:
            print("[Task] Picking action completed.")
            return
        
        # 4. Pull the drawer open
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Drawer opened successfully.")
            return

        # 5. Place the object in the drawer or any further actions needed
        # Assuming we have completed the task
        print("[Task] Placing the object in the drawer or continuing further actions.")
        obs, reward, done = place(env, 'object_to_place', drawer_pos)
        if done:
            print("[Task] Object placed successfully in the drawer.")
            return
    
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()