def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        tomato_pos = positions['tomato']
        drawer_pos = positions['drawer']  # Adjust based on your environment setup
        
        # Step 1: Move to the drawer position
        print("[Task] Moving to drawer position...")
        obs, reward, done = move(env, drawer_pos[0], drawer_pos[1])
        if done:
            print("[Task] Task ended after moving to the drawer position!")
            return

        # Step 2: Rotate gripper to open drawer
        print("[Task] Rotating gripper to open drawer...")
        target_quat = [0, 0, 0, 1]  # Adjust this quaternion based on your needs
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Task ended after rotating gripper!")
            return

        # Step 3: Pull to open the drawer
        print("[Task] Pulling drawer handle...")
        obs, reward, done = pull(env, 'drawer')
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 4: Move to the tomato position
        print("[Task] Moving to tomato position...")
        obs, reward, done = move(env, tomato_pos[0], tomato_pos[1])
        if done:
            print("[Task] Task ended after moving to the tomato position!")
            return

        # Step 5: Pick the tomato
        print("[Task] Picking the tomato...")
        obs, reward, done = pick(env, 'tomato', tomato_pos)
        if done:
            print("[Task] Task ended after picking the tomato!")
            return

        # Step 6: Move back to the drawer with the tomato
        print("[Task] Moving back to the drawer with the tomato...")
        obs, reward, done = move(env, tomato_pos[0], drawer_pos[1])
        if done:
            print("[Task] Task ended after moving back to the drawer with the tomato!")
            return

        # Step 7: Place the tomato inside the drawer
        print("[Task] Placing the tomato inside the drawer...")
        obs, reward, done = place(env, 'tomato', 'drawer')
        if done:
            print("[Task] Task ended after placing the tomato in the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()