def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assume 'drawer' is one of the objects that we need
        drawer_position = positions['drawer']
        gripper_position = positions['gripper']
        
        # Steps to execute the oracle plan
        print("[Task] Moving to the drawer's position...")
        obs, reward, done = move(env, "room1", "drawer_room")
        if done:
            print("[Task] Task ended after moving to the drawer position!")
            return

        print("[Task] Picking the drawer's handle...")
        obs, reward, done = pick(env, 'drawer_handle', 'drawer_room', 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer handle!")
            return

        print("[Task] Opening the drawer...")
        obs, reward, done = pull(env, 'drawer_handle', 'gripper', 'drawer_room')
        if done:
            print("[Task] Task ended after opening the drawer!")
            return
            
        print("[Task] Placing the object...")
        obs, reward, done = place(env, 'drawer_object', 'drawer_room')
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()