def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # The following identifiers are placeholders; replace with your actual objects
        drawer = 'drawer1'  # Example drawer object
        gripper = 'gripper1'  # Example gripper object
        robot = 'robot1'  # Example robot object
        room = 'room1'  # Example location

        # Moving to the drawer
        print("[Task] Moving to the drawer...")
        move(env, robot, 'start_position', room)

        # Picking the drawer
        print("[Task] Picking the drawer...")
        pick(env, drawer, room, gripper)

        # Rotating the gripper to the necessary angle
        print("[Task] Rotating gripper...")
        rotate(env, task, target_quat=[0, 0, 0, 1])  # Adjust quaternion accordingly

        # Pulling the drawer to open it
        print("[Task] Pulling the drawer...")
        if not is_locked(drawer):  # Check lock state
            pull(env, gripper, drawer)

        # Placing the item back or dropping it in a new location
        print("[Task] Placing the item...")
        place(env, drawer, room)

    except Exception as e:
        print(f"An error occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()