def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Loop through a sequence of actions
        # Assuming positions contains objects to manipulate
        for obj in positions.keys():
            obj_pos = positions[obj]
            
            # 1. Move to the object's position
            obs = move(env, 'initial_room', obj_pos)
            if obs.done:
                print("[Task] Task ended during move to object!")
                return

            # 2. Pick the object
            obs = pick(env, obj, obj_pos, 'gripper')
            if obs.done:
                print("[Task] Task ended during picking the object!")
                return

            # 3. Move to the desired location
            obs = move(env, obj_pos, 'target_room')
            if obs.done:
                print("[Task] Task ended during move to target room!")
                return
            
            # 4. Place the object down
            obs = place(env, obj, 'target_room')
            if obs.done:
                print("[Task] Task ended during placing the object!")
                return

        print("===== Completed All Tasks Successfully! =====")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()