def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # TODO: Assuming we have an object 'item' to manipulate and a room
        item_pos = positions['item']  # Replace 'item' with the actual object name.
        room_pos = positions['room']   # Replace 'room' with the actual room name.

        # 1. Move robot to the room where the item is located
        print("[Task] Moving to the room...")
        obs, reward, done = move(env, task, room_pos)

        if done:
            print("[Task] Ended after moving to room!")
            return

        # 2. Pick up the item
        print("[Task] Picking up the item...")
        obs, reward, done = pick(env, task, 'item', 'room', 'gripper')  # 'gripper' as the tool identifier, can vary.

        if done:
            print("[Task] Ended after picking the item!")
            return

        # 3. Place the item somewhere, for example back to the room
        print("[Task] Placing the item...")
        obs, reward, done = place(env, task, 'item', 'room')

        if done:
            print("[Task] Ended after placing the item!")
            return
        
    except Exception as e:
        print(f"Error during task execution: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()