def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Identify the relevant positions for execution
        drawer_pos = positions['drawer_pos']  # Assume keys exist
        plate_pos = positions['plate_pos']     # Assume keys exist
        tomato1_pos = positions['tomato1_pos'] # Assume keys exist
        tomato2_pos = positions['tomato2_pos'] # Assume keys exist

        # 1. Move to the drawer to check if it's open
        print("[Task] Moving to the drawer to check if it's open.")
        obs, reward, done = move(env, task, obs.robot_position, drawer_pos)
        if done:
            print("[Task] Task ended unexpectedly while moving to the drawer.")
            return

        # 2. Open the drawer if it is not locked
        print("[Task] Attempting to pick the drawer handle.")
        obs, reward, done = pick(env, "drawer_handle", drawer_pos, obs.gripper)
        if done:
            print("[Task] Task ended unexpectedly while picking the drawer handle.")
            return
        
        print("[Task] Attempting to pull the drawer.")
        obs, reward, done = pull(env, obs.gripper, "drawer")
        if done:
            print("[Task] Task ended unexpectedly while pulling the drawer.")
            return
            
        # Check if the drawer is open
        if not obs.drawer_open:
            print("[Task] The drawer is still not open, cannot proceed.")
            return

        # 3. Pick tomatoes from the drawer
        print("[Task] Picking up tomato 1.")
        obs, reward, done = pick(env, "tomato1", drawer_pos, obs.gripper)
        if done:
            print("[Task] Task ended unexpectedly while picking the first tomato.")
            return

        # 4. Move to the plate to drop the first tomato
        print("[Task] Moving to the plate to drop the first tomato.")
        obs, reward, done = move(env, task, obs.robot_position, plate_pos)
        if done:
            print("[Task] Task ended unexpectedly while moving to the plate.")
            return

        # 5. Drop the first tomato onto the plate
        print("[Task] Dropping the first tomato onto the plate.")
        obs, reward, done = place(env, "tomato1", plate_pos)
        if done:
            print("[Task] Task ended unexpectedly while placing the first tomato.")
            return

        # 6. Pick the second tomato from the drawer
        print("[Task] Picking up tomato 2.")
        obs, reward, done = pick(env, "tomato2", drawer_pos, obs.gripper)
        if done:
            print("[Task] Task ended unexpectedly while picking the second tomato.")
            return

        # 7. Move to the plate again
        print("[Task] Moving to the plate to drop the second tomato.")
        obs, reward, done = move(env, task, obs.robot_position, plate_pos)
        if done:
            print("[Task] Task ended unexpectedly while moving to the plate.")
            return

        # 8. Drop the second tomato onto the plate
        print("[Task] Dropping the second tomato onto the plate.")
        obs, reward, done = place(env, "tomato2", plate_pos)
        if done:
            print("[Task] Task ended unexpectedly while placing the second tomato.")
            return

    except Exception as e:
        print(f"[Error] An exception occurred: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()