def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assumed object names based on plan
        tomato_pos = positions['tomato']
        drawer_pos = positions['drawer']
        side_pos = positions['side_pos']
        anchor_pos = positions['anchor_pos']

        # === Execute the Plan ===
        
        # Move to the drawer
        print("[Task] Moving to drawer at:", drawer_pos)
        obs, reward, done = move(env, obs.robot_position, drawer_pos)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        # Pick the drawer
        print("[Task] Picking drawer.")
        obs, reward, done = pick(env, 'drawer', drawer_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking drawer!")
            return

        # Open the drawer
        print("[Task] Opening drawer.")
        obs, reward, done = pull(env, 'gripper', 'drawer', drawer_pos)
        if done:
            print("[Task] Task ended after opening drawer!")
            return
            
        # Move to tomato
        print("[Task] Moving to tomato at:", tomato_pos)
        obs, reward, done = move(env, obs.robot_position, tomato_pos)
        if done:
            print("[Task] Task ended after moving to tomato!")
            return
        
        # Pick the tomato
        print("[Task] Picking tomato.")
        obs, reward, done = pick(env, 'tomato', tomato_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking tomato!")
            return
        
        # Move back to the drawer to place the tomato
        print("[Task] Moving back to drawer to place tomato.")
        obs, reward, done = move(env, obs.robot_position, drawer_pos)
        if done:
            print("[Task] Task ended after moving back to drawer!")
            return
        
        # Place the tomato into the drawer
        print("[Task] Placing tomato into drawer.")
        obs, reward, done = place(env, 'tomato', drawer_pos)
        if done:
            print("[Task] Task ended after placing tomato!")
            return
            
        print("[Task] Completed all steps successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()