def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects in the environment based on PDDL
        object1_pos = positions['object1']
        object2_pos = positions['object2']
        gripper_position = positions['gripper']

        # 1) Move to object1
        print("[Task] Moving to object1 at:", object1_pos)
        obs, reward, done = move(env, task, gripper_position, object1_pos)
        if done:
            print("[Task] Task ended after moving to object1!")
            return

        # 2) Pick up object1
        print("[Task] Picking object1.")
        obs, reward, done = pick(env, 'object1', object1_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking object1!")
            return

        # 3) Move to the drop-off position
        drop_position = positions['drop_zone']
        print("[Task] Moving to drop-off position:", drop_position)
        obs, reward, done = move(env, task, object1_pos, drop_position)
        if done:
            print("[Task] Task ended after moving to drop-off position!")
            return

        # 4) Place object1 down
        print("[Task] Placing object1 down.")
        obs, reward, done = place(env, 'object1', drop_position)
        if done:
            print("[Task] Task ended after placing object1!")
            return

        # 5) Move back to pick up object2
        print("[Task] Moving to object2 at:", positions['object2'])
        obs, reward, done = move(env, task, drop_position, positions['object2'])
        if done:
            print("[Task] Task ended after moving to object2!")
            return
        
        # 6) Pick up object2
        print("[Task] Picking object2.")
        obs, reward, done = pick(env, 'object2', positions['object2'], 'gripper')
        if done:
            print("[Task] Task ended after picking object2!")
            return

        # 7) Move to final drop-off area
        print("[Task] Moving to final drop-off zone.")
        obs, reward, done = move(env, task, positions['object2'], drop_position)
        if done:
            print("[Task] Task ended while moving to final drop-off zone!")
            return

        # 8) Drop object2
        print("[Task] Placing object2 down.")
        obs, reward, done = place(env, 'object2', drop_position)
        if done:
            print("[Task] Task ended after placing object2!")
            return
            
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()