def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Example placeholders, assuming we have a 'drawer' in the environment
        drawer_pos = positions.get('drawer', (0, 0, 0))  # Replace 'drawer' with actual object name if needed
        gripper = 'gripper_0'  # Assuming a specific gripper identifier
        current_position = (0, 0, 0)  # Initial position of the robot
        
        # Execution Plan
        print("[Task] Moving to the drawer position:", drawer_pos)
        obs, reward, done = move(env, current_position, drawer_pos)
        
        if done:
            print("[Task] Task ended after moving to the drawer position!")
            return
        
        print("[Task] Picking the drawer handle.")
        obs, reward, done = pick(env, 'drawer_handle', drawer_pos, gripper)
        
        if done:
            print("[Task] Task ended after picking the drawer handle!")
            return
        
        print("[Task] Rotating to open the drawer.")
        obs, reward, done = rotate(env, task, target_quat=[0, 0, 0, 1])  # Example quaternion, adjust as needed
        
        if done:
            print("[Task] Task ended after rotating!")
            return
        
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, gripper, 'drawer')
        
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return
        
        print("[Task] Placing the drawer handle back.")
        obs, reward, done = place(env, 'drawer_handle', drawer_pos)
        
        if done:
            print("[Task] Task completed successfully!")
    
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()