def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer in the environment
        gripper = 'gripper'  # Placeholder for the actual gripper object
        drawer = 'drawer'     # Placeholder for the actual drawer object
        bottom_position = 'bottom'  # Placeholder for the actual position of the drawer

        # Step 1: Move to the drawer's side position
        print("[Task] Moving to the side position of the drawer.")
        move(env, 'current_room', 'side_position')  # Replace with actual room names

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        pick_drawing(env, gripper, drawer, bottom_position)

        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer.")
        pull(env, gripper, drawer)

        # Step 4: Place the drawer back (if needed)
        print("[Task] Placing the drawer back.")
        place(env, drawer, 'original_position')  # Replace with actual position

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()