def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer in the environment
        gripper = 'gripper'  # Placeholder for the actual gripper object
        drawer = 'drawer'  # Placeholder for the actual drawer object
        initial_position = positions['initial_position']  # Placeholder for the robot's initial position
        target_object = 'target_object'  # Placeholder for the object to be manipulated

        # Step 1: Move to the initial position
        print("[Task] Moving to initial position.")
        obs, reward, done = move(env, initial_position, target_object)
        if done:
            print("[Task] Task ended after moving to initial position!")
            return

        # Step 2: Pick the target object
        print("[Task] Picking the target object.")
        obs, reward, done = pick(env, target_object, initial_position, gripper)
        if done:
            print("[Task] Task ended after picking the target object!")
            return

        # Step 3: Move to the drawer
        print("[Task] Moving to the drawer.")
        obs, reward, done = move(env, target_object, drawer)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # Step 4: Place the object in the drawer
        print("[Task] Placing the object in the drawer.")
        obs, reward, done = place(env, target_object, drawer)
        if done:
            print("[Task] Task ended after placing the object in the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()