def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer in the environment
        gripper = 'gripper'  # Placeholder for the actual gripper object
        drawer = 'drawer'     # Placeholder for the actual drawer object
        room = 'room'         # Placeholder for the actual room location

        # Example plan execution
        # 1) Move to the drawer
        print("[Task] Moving to the drawer.")
        obs, reward, done = move(env, room, drawer)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # 2) Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, drawer, room, gripper)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # 3) Rotate the gripper to the desired angle
        target_angle = 'desired_angle'  # Placeholder for the actual target angle
        print("[Task] Rotating the gripper.")
        obs, reward, done = rotate(env, task, target_angle)
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return

        # 4) Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # 5) Place the object (if applicable)
        print("[Task] Placing the object.")
        obs, reward, done = place(env, 'object', room)  # Replace 'object' with the actual object
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()