def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer in the environment
        gripper = 'gripper_1'  # Placeholder for the actual gripper object
        drawer = 'drawer_1'     # Placeholder for the actual drawer object
        initial_position = 'initial_room'  # Placeholder for the robot's initial position

        # Move to the initial position
        print("[Task] Moving to initial position:", initial_position)
        obs, reward, done = move(env, initial_position, 'target_room')
        if done:
            print("[Task] Task ended after moving to initial position!")
            return

        # Pick the drawer
        print("[Task] Picking the drawer at position:", positions[drawer])
        obs, reward, done = pick(env, drawer, positions[drawer], gripper)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Rotate the gripper to the desired angle
        target_angle = 'ninety_deg'  # Placeholder for the actual target angle
        print("[Task] Rotating gripper to angle:", target_angle)
        obs, reward, done = rotate(env, task, target_angle)
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return

        # Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Place the object back in the drawer
        print("[Task] Placing the object back in the drawer.")
        obs, reward, done = place(env, drawer, positions[drawer])
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()