def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer in the environment
        gripper = 'gripper'  # Placeholder for the actual gripper object
        drawer = 'drawer'     # Placeholder for the actual drawer object
        initial_position = 'initial_position'  # Placeholder for the initial position of the robot

        # Step 1: Rotate the gripper to the initial position
        print("[Task] Rotating gripper to initial position.")
        obs, reward, done = rotate(env, task, target_quat=[0, 0, 0, 1])  # Assuming zero rotation is the target
        if done:
            print("[Task] Task ended after rotating gripper!")
            return

        # Step 2: Move to the initial position
        print("[Task] Moving to initial position.")
        obs, reward, done = move(env, initial_position, 'target_position')  # Replace 'target_position' with actual target
        if done:
            print("[Task] Task ended after moving to initial position!")
            return

        # Step 3: Pick the object
        print("[Task] Picking the object.")
        obs, reward, done = pick(env, 'object', 'location')  # Replace 'object' and 'location' with actual values
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 4: Place the object
        print("[Task] Placing the object.")
        obs, reward, done = place(env, 'object', 'target_location')  # Replace 'target_location' with actual value
        if done:
            print("[Task] Task ended after placing the object!")
            return

        # Step 5: Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, gripper, drawer)  # Assuming gripper is holding the drawer
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()