def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer to interact with
        gripper = 'gripper'  # Placeholder for the actual gripper object
        drawer = 'drawer'     # Placeholder for the actual drawer object
        object_1 = 'object_1' # Placeholder for the actual object to pick
        object_2 = 'object_2' # Placeholder for the actual object to place

        # Example positions (replace with actual positions from the environment)
        object_1_pos = positions[object_1]
        object_2_pos = positions[object_2]
        drawer_pos = positions[drawer]

        # Step 1: Move to the drawer position
        print("[Task] Moving to drawer position:", drawer_pos)
        obs, reward, done = move(env, task, target_pos=drawer_pos)
        if done:
            print("[Task] Task ended while moving to drawer!")
            return

        # Step 2: Pick the object from the drawer
        print("[Task] Picking object:", object_1)
        obs, reward, done = pick(env, object_1, drawer_pos, gripper)
        if done:
            print("[Task] Task ended while picking object!")
            return

        # Step 3: Move to the placement position
        print("[Task] Moving to placement position:", object_2_pos)
        obs, reward, done = move(env, task, target_pos=object_2_pos)
        if done:
            print("[Task] Task ended while moving to placement position!")
            return

        # Step 4: Place the object
        print("[Task] Placing object:", object_1)
        obs, reward, done = place(env, object_1, object_2_pos)
        if done:
            print("[Task] Task ended while placing object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()