def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer to interact with
        gripper = 'gripper'  # Placeholder for the actual gripper object
        drawer = 'drawer'     # Placeholder for the actual drawer object
        initial_position = 'initial_position'  # Placeholder for the robot's initial position
        side_position = 'side_position'  # Placeholder for the side position of the drawer
        anchor_position = 'anchor_position'  # Placeholder for the anchor position of the drawer

        # Step 1: Rotate the gripper to the initial position
        obs, reward, done = rotate(env, task, initial_quat)  # Assuming initial_quat is defined
        if done:
            print("[Task] Task ended after rotating to initial position!")
            return

        # Step 2: Move to the side position of the drawer
        obs, reward, done = move(env, initial_position, side_position)
        if done:
            print("[Task] Task ended after moving to side position!")
            return

        # Step 3: Pick the drawer
        obs, reward, done = pick_drawer(env, gripper, drawer, side_position)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 4: Pull the drawer
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 5: Rotate the gripper to the desired angle (if needed)
        obs, reward, done = rotate(env, task, target_quat)  # Assuming target_quat is defined
        if done:
            print("[Task] Task ended after rotating to target angle!")
            return

        # Step 6: Place the drawer back (if needed)
        obs, reward, done = place(env, drawer, initial_position)
        if done:
            print("[Task] Task ended after placing the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()