def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer in the environment
        gripper = 'gripper'  # Placeholder for the actual gripper object
        drawer = 'drawer'     # Placeholder for the actual drawer object
        initial_position = 'initial_room'  # Placeholder for the robot's initial position

        # Step 1: Move to the initial position
        print("[Task] Moving to initial position:", initial_position)
        obs, reward, done = move(env, initial_position, 'target_room')
        if done:
            print("[Task] Task ended after moving to initial position!")
            return

        # Step 2: Pick the object
        object_to_pick = 'object1'  # Placeholder for the actual object to pick
        print("[Task] Picking object:", object_to_pick)
        obs, reward, done = pick(env, object_to_pick, 'target_room', gripper)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to the drawer
        print("[Task] Moving to the drawer")
        obs, reward, done = move(env, 'target_room', 'drawer_room')
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # Step 4: Place the object in the drawer
        print("[Task] Placing object in the drawer")
        obs, reward, done = place(env, object_to_pick, drawer)
        if done:
            print("[Task] Task ended after placing the object!")
            return

        # Step 5: Rotate the gripper if needed
        target_quat = [0, 0, 0, 1]  # Placeholder for the target quaternion
        print("[Task] Rotating gripper to target orientation")
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return

        # Step 6: Pull the drawer if needed
        print("[Task] Pulling the drawer")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()