import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        plate_pos = positions['plate']
        bottom_drawer_pos = positions['bottom_anchor_pos']  # Assuming this is the position of the bottom drawer

        # Step 1: Pull open any drawer that is not locked
        print("[Task] Pulling open the bottom drawer.")
        obs, reward, done = pull(env, task)
        if done:
            print("[Task] Drawer opened successfully!")
        else:
            print("[Task] Failed to open the drawer.")

        # Step 2: Place the tomatoes onto the plate
        print("[Task] Placing tomatoes onto the plate.")
        obs, reward, done = place(env, task)
        if done:
            print("[Task] Tomatoes placed successfully on the plate!")
        else:
            print("[Task] Failed to place tomatoes on the plate.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()