def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        bottom_drawer_pos = positions['bottom_drawer']
        top_drawer_pos = positions['top_drawer']
        object_1_pos = positions['object_1']  # Example object
        object_2_pos = positions['object_2']  # Example object

        # Step 1: Move to the bottom drawer position
        print("[Task] Moving to bottom drawer position:", bottom_drawer_pos)
        obs, reward, done = move(env, task, target_pos=bottom_drawer_pos)
        if done:
            print("[Task] Task ended after moving to bottom drawer!")
            return

        # Step 2: Pick the drawer
        print("[Task] Picking the bottom drawer.")
        obs, reward, done = pick(env, 'bottom_drawer', bottom_drawer_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 3: Pull the drawer
        print("[Task] Pulling the bottom drawer.")
        obs, reward, done = pull(env, 'bottom_drawer', bottom_drawer_pos)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 4: Move to the top drawer position
        print("[Task] Moving to top drawer position:", top_drawer_pos)
        obs, reward, done = move(env, task, target_pos=top_drawer_pos)
        if done:
            print("[Task] Task ended after moving to top drawer!")
            return

        # Step 5: Pick the drawer
        print("[Task] Picking the top drawer.")
        obs, reward, done = pick(env, 'top_drawer', top_drawer_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 6: Pull the drawer
        print("[Task] Pulling the top drawer.")
        obs, reward, done = pull(env, 'top_drawer', top_drawer_pos)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()