def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming drawer and rubbish details are already present in the object_positions
        bottom_side_pos = positions.get('bottom_side_pos')
        bottom_anchor_pos = positions.get('bottom_anchor_pos')
        rubbish_pos = positions.get('rubbish')

        # Example task plan for open drawer and put rubbish in it
        print("[Task] Moving to the drawer...")
        obs, reward, done = move(env, task, obs.robot_position, bottom_side_pos)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        print("[Task] Picking the drawer...")
        obs, reward, done = pick(env, 'drawer', bottom_side_pos)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return
        
        print("[Task] Pulling the drawer open...")
        obs, reward, done = pull(env, 'drawer', bottom_anchor_pos)
        if done:
            print("[Task] Task ended after pulling the drawer open!")
            return

        print("[Task] Moving to the rubbish...")
        obs, reward, done = move(env, task, obs.robot_position, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return
        
        print("[Task] Picking up the rubbish...")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos)
        if done:
            print("[Task] Task ended after picking rubbish!")
            return

        print("[Task] Placing rubbish into the drawer...")
        obs, reward, done = place(env, 'rubbish', 'drawer')
        if done:
            print("[Task] Task ended after placing rubbish into drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()