def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects and positions are set as follows:
        bottom_pos = positions['bottom']
        middle_pos = positions['middle']
        top_pos = positions['top']
        bottom_side_pos = positions['bottom_side_pos']
        middle_side_pos = positions['middle_side_pos']
        top_side_pos = positions['top_side_pos']
        gripper_pos = positions['gripper']

        # === Example Task Plan ===
        
        # Move to the bottom drawer
        print("[Task] Moving to bottom drawer side position.")
        obs, reward, done = move(env, gripper_pos, bottom_side_pos)
        if done:
            print("[Task] Task ended after moving to the bottom drawer side position!")
            return
        
        # Pick the bottom drawer
        print("[Task] Picking bottom drawer.")
        obs, reward, done = pick(env, 'bottom', bottom_pos)
        if done:
            print("[Task] Task ended after picking the bottom drawer!")
            return

        # Move to open the drawer
        print("[Task] Moving to open bottom drawer.")
        obs, reward, done = move(env, bottom_side_pos, bottom_pos)
        if done:
            print("[Task] Task ended after moving to open the bottom drawer!")
            return
        
        # Pull the bottom drawer open
        print("[Task] Pulling bottom drawer open.")
        obs, reward, done = pull(env, 'bottom', bottom_pos)
        if done:
            print("[Task] Task ended after pulling the bottom drawer open!")
            return

        # Move to the middle drawer position
        print("[Task] Moving to middle drawer side position.")
        obs, reward, done = move(env, bottom_pos, middle_side_pos)
        if done:
            print("[Task] Task ended after moving to the middle drawer side position!")
            return

        # Pick the middle drawer
        print("[Task] Picking middle drawer.")
        obs, reward, done = pick(env, 'middle', middle_pos)
        if done:
            print("[Task] Task ended after picking the middle drawer!")
            return
        
        # Move to open the middle drawer
        print("[Task] Moving to open middle drawer.")
        obs, reward, done = move(env, middle_side_pos, middle_pos)
        if done:
            print("[Task] Task ended after moving to open the middle drawer!")
            return
        
        # Pull the middle drawer open
        print("[Task] Pulling middle drawer open.")
        obs, reward, done = pull(env, 'middle', middle_pos)
        if done:
            print("[Task] Task ended after pulling the middle drawer open!")
            return

        # Move to the top drawer position
        print("[Task] Moving to top drawer side position.")
        obs, reward, done = move(env, middle_pos, top_side_pos)
        if done:
            print("[Task] Task ended after moving to the top drawer side position!")
            return

        # Pick the top drawer
        print("[Task] Picking top drawer.")
        obs, reward, done = pick(env, 'top', top_pos)
        if done:
            print("[Task] Task ended after picking the top drawer!")
            return

        # Move to open the top drawer
        print("[Task] Moving to open top drawer.")
        obs, reward, done = move(env, top_side_pos, top_pos)
        if done:
            print("[Task] Task ended after moving to open the top drawer!")
            return
        
        # Pull the top drawer open
        print("[Task] Pulling top drawer open.")
        obs, reward, done = pull(env, 'top', top_pos)
        if done:
            print("[Task] Task ended after pulling the top drawer open!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()