def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the positions based on the object names in the environment
        bottom_side_pos = positions.get('bottom_side_pos')
        bottom_anchor_pos = positions.get('bottom_anchor_pos')
        rubbish_pos = positions.get('rubbish_bin')  # Assuming there is a rubbish bin

        # 1) Move to the bottom side position to pick the drawer handle
        print("[Task] Moving to the bottom side position to pick the drawer.")
        obs, reward, done = move(env, task, "current_position", bottom_side_pos)
        if done:
            print("[Task] Task ended while moving to the drawer.")
            return

        # 2) Pick the drawer handle
        print("[Task] Picking the drawer handle.")
        obs, reward, done = pick(env, "drawer_handle", bottom_side_pos, "gripper")
        if done:
            print("[Task] Task ended while picking the drawer handle.")
            return

        # 3) Rotate the gripper to the position for pulling
        print("[Task] Rotating the gripper to pull the drawer.")
        rotate(env, task, target_quat=[0, 0, 0, 1], max_steps=100)  # Adjust quaternion as needed

        # 4) Pull the drawer
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, "drawer", bottom_anchor_pos)
        if done:
            print("[Task] Task ended while pulling the drawer.")
            return

        # 5) Move to the rubbish bin to drop the rubbish
        print("[Task] Moving to the rubbish bin.")
        obs, reward, done = move(env, task, bottom_anchor_pos, rubbish_pos)
        if done:
            print("[Task] Task ended while moving to the rubbish bin.")
            return

        # 6) Place the rubbish in the rubbish bin
        print("[Task] Placing the rubbish in the rubbish bin.")
        obs, reward, done = place(env, "rubbish", rubbish_pos)
        if done:
            print("[Task] Task ended while placing the rubbish.")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()