def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Retrieve necessary object positions
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        drawer_pos = positions['drawer']

        # Move towards the drawer
        print("[Task] Moving to the drawer.")
        obs = move(env, 'current_location', drawer_pos)

        # Check if the drawer is locked before attempting to open it
        if not obs['is_locked']:
            print("[Task] Pulling the drawer open.")
            obs = pull(env, task, draw_distance=0.2)

            # Check if the drawer is open
            if obs['is_open']:
                print("[Task] Picking up the rubbish.")
                obs = pick(env, 'rubbish', drawer_pos)

                # Move to the bin to drop the rubbish
                print("[Task] Moving to the bin.")
                obs = move(env, 'drawer_pos', bin_pos)

                # Drop the rubbish into the bin
                print("[Task] Dropping the rubbish into the bin.")
                obs = place(env, 'rubbish', bin_pos)
            else:
                print("[Task] The drawer could not be opened.")
        else:
            print("[Task] The drawer is locked and cannot be opened.")

    except Exception as e:
        print(f"[Error] An error occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()