def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions:
        drawer_position = positions['drawer']
        gripper_position = positions['gripper']
        rubbish_position = positions['rubbish']

        # 1) Move to the drawer
        print("[Task] Moving to the drawer at:", drawer_position)
        obs, reward, done = move(env, 'current_location', drawer_position)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # 2) Check if the drawer is locked
        print("[Task] Checking if the drawer is locked...")
        if not obs.is_locked:
            print("[Task] The drawer is not locked, proceeding to open it.")
            obs, reward, done = pull(env, 'gripper', drawer_position)
            if done:
                print("[Task] Task ended after attempting to pull the drawer!")
                return
        else:
            print("[Task] The drawer is locked, cannot proceed.")

        # 3) If the drawer is open, proceed to pick up rubbish
        print("[Task] Moving to the rubbish at:", rubbish_position)
        obs, reward, done = move(env, drawer_position, rubbish_position)
        if done:
            print("[Task] Task ended after moving to the rubbish!")
            return

        # 4) Try to pick up rubbish
        print("[Task] Picking up the rubbish...")
        obs, reward, done = pick(env, 'rubbish', rubbish_position)
        if done:
            print("[Task] Task ended after picking up the rubbish!")
            return

        # 5) Return to the original position and drop the rubbish
        print("[Task] Moving back to the original position...")
        obs, reward, done = move(env, rubbish_position, 'original_position')
        if done:
            print("[Task] Task ended after returning to original position!")
            return

        # 6) Drop the rubbish
        print("[Task] Dropping the rubbish...")
        obs, reward, done = place(env, 'rubbish', 'original_position')
        if done:
            print("[Task] Task ended after dropping the rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()