def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        bottom_pos = positions['bottom']  # Placeholder for actual object name
        middle_pos = positions['middle']  # Placeholder for actual object name
        top_pos = positions['top']        # Placeholder for actual object name

        # Execute the robot activities based on the actions to achieve the goal
        
        # Move to bottom position
        print("[Task] Moving to bottom position...")
        obs, reward, done = move(env, 'nowhere', bottom_pos)
        if done:
            print("[Task] Task ended while moving to the bottom.")
            return

        # Pick up the bottom drawer
        print("[Task] Picking the bottom drawer...")
        obs, reward, done = pick(env, 'bottom_drawer', bottom_pos)
        if done:
            print("[Task] Task ended while picking bottom drawer.")
            return

        # Move to middle position
        print("[Task] Moving to middle position...")
        obs, reward, done = move(env, bottom_pos, middle_pos)
        if done:
            print("[Task] Task ended while moving to the middle.")
            return
        
        # Pick up the middle drawer
        print("[Task] Picking the middle drawer...")
        obs, reward, done = pick(env, 'middle_drawer', middle_pos)
        if done:
            print("[Task] Task ended while picking middle drawer.")
            return

        # Move to top position
        print("[Task] Moving to top position...")
        obs, reward, done = move(env, middle_pos, top_pos)
        if done:
            print("[Task] Task ended while moving to the top.")
            return
        
        # Place the top drawer
        print("[Task] Placing the top drawer...")
        obs, reward, done = place(env, 'top_drawer', top_pos)
        if done:
            print("[Task] Task ended while placing top drawer.")
            return
        
        print("===== Finished executing the task! =====")
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()