def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a drawer named 'drawer', and the robot is already initialized
        drawer_position = positions['drawer']  # Use the actual object name from your environment
        rubbish_position = positions['rubbish']  # Using 'rubbish' object from the environment
        bin_position = positions['bin']  # Position of the bin where rubbish needs to be dropped
        
        # Move robot to drawer position
        print("[Task] Moving to the drawer position:", drawer_position)
        obs, reward, done = move(env, task, "current_room", drawer_position)
        
        if done: return
        
        # Check if the drawer can be pulled
        print("[Task] Attempting to pull the drawer.")
        obs, reward, done = pull(env, task, 'drawer')
        
        if done: return
        
        # Move to the rubbish position
        print("[Task] Moving to the rubbish position:", rubbish_position)
        obs, reward, done = move(env, task, "current_room", rubbish_position)
        
        if done: return
        
        # Pick up the rubbish
        print("[Task] Picking up the rubbish.")
        obs, reward, done = pick(env, 'rubbish', rubbish_position)

        if done: return
        
        # Move back to the drawer position to drop the rubbish
        print("[Task] Moving back to the drawer position to drop the rubbish.")
        obs, reward, done = move(env, task, drawer_position, "current_room")
        
        if done: return
        
        # Drop the rubbish into the bin
        print("[Task] Dropping rubbish into the bin.")
        obs, reward, done = place(env, 'rubbish', bin_position)

        if done: return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()