def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        robot_position = positions['robot']  # Replace 'robot' with actual robot object key
        drawer_position = positions['drawer']  # Replace 'drawer' with actual drawer object key
        object_position = positions['object']  # Replace 'object' with actual object key

        # Example Task Plan
        print("[Task] Moving to the drawer position.")
        obs, reward, done = move(env, robot_position, drawer_position)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        print("[Task] Picking up the object.")
        obs, reward, done = pick(env, 'object', drawer_position, 'gripper')
        if done:
            print("[Task] Task ended after picking an object!")
            return

        print("[Task] Placing the object at the designated position.")
        obs, reward, done = place(env, 'object', 'target_position')  # Replace 'target_position' with actual position
        if done:
            print("[Task] Task ended after placing the object!")
            return

        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, 'gripper', 'drawer')  # Replace with actual gripper and drawer references
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()