def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        drawer_pos = positions['drawer']  # Assuming drawer position is defined in the environment

        # 1) Move to the drawer to open it
        print(f"[Task] Moving to the drawer at: {drawer_pos}")
        obs, reward, done = move(env, obs.robot_position, drawer_pos)
        if done:
            print("[Task] Task ended while moving to the drawer!")
            return

        # 2) Rotate the gripper for opening the drawer
        print("[Task] Rotating gripper to open the drawer.")
        obs, reward, done = rotate(env, obs.gripper_angle, ninety_deg)
        if done:
            print("[Task] Task ended while rotating the gripper!")
            return

        # 3) Pull the drawer open
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, task, 0.1)  # Pulling a small distance
        if done:
            print("[Task] Task ended while pulling the drawer!")
            return

        # 4) Move to rubbish to pick it up
        print(f"[Task] Moving to rubbish at: {rubbish_pos}")
        obs, reward, done = move(env, obs.robot_position, rubbish_pos)
        if done:
            print("[Task] Task ended while moving to rubbish!")
            return

        # 5) Pick up the rubbish
        print("[Task] Picking up the rubbish.")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos)
        if done:
            print("[Task] Task ended while picking the rubbish!")
            return

        # 6) Move to the bin to drop the rubbish
        print(f"[Task] Moving to the bin at: {bin_pos}")
        obs, reward, done = move(env, obs.robot_position, bin_pos)
        if done:
            print("[Task] Task ended while moving to the bin!")
            return

        # 7) Drop the rubbish in the bin
        print("[Task] Dropping the rubbish in the bin.")
        obs, reward, done = place(env, 'rubbish', bin_pos)
        if done:
            print("[Task] Task ended while placing the rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()