def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming object names and their positions from the positions dictionary
        rubbish_pos = positions.get('rubbish', None)
        bin_pos = positions.get('bin', None)
        drawer_pos = positions.get('drawer', None)  # Assuming we also have drawer positions
        bottom_anchor_pos = positions.get('bottom_anchor_pos', None)
        middle_anchor_pos = positions.get('middle_anchor_pos', None)

        # Check if any necessary position is None and handle it
        if rubbish_pos is None or bin_pos is None or drawer_pos is None:
            print("Missing necessary object positions. Terminating task.")
            return
        
        # Step 1: Move to the drawer and open it
        print("[Task] Moving to the drawer position:", drawer_pos)
        obs, reward, done = move(env, task, obs.robot_location, drawer_pos)
        
        if done:
            print("[Task] Task ended while moving to the drawer!")
            return

        print("[Task] Opening the drawer.")
        obs, reward, done = pull(env, task, drawer_pos)

        if done:
            print("[Task] Task ended while opening the drawer!")
            return

        # Step 2: Move to the rubbish
        print("[Task] Moving to the rubbish position:", rubbish_pos)
        obs, reward, done = move(env, task, obs.robot_location, rubbish_pos)

        if done:
            print("[Task] Task ended while moving to the rubbish!")
            return

        print("[Task] Picking up the rubbish.")
        obs, reward, done = pick(env, task, 'rubbish', rubbish_pos)

        if done:
            print("[Task] Task ended while picking up the rubbish!")
            return

        # Step 3: Move to the bin
        print("[Task] Moving to the bin position:", bin_pos)
        obs, reward, done = move(env, task, obs.robot_location, bin_pos)

        if done:
            print("[Task] Task ended while moving to the bin!")
            return

        print("[Task] Placing the rubbish in the bin.")
        obs, reward, done = place(env, task, 'rubbish', bin_pos)

        if done:
            print("[Task] Task ended while placing the rubbish in the bin!")
            return

        print("===== Task Completed Successfully =====")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()