def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming object's positions are given as follows
        bottom_drawer_pos = positions['bottom_drawer']
        top_drawer_pos = positions['top_drawer']
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        gripper_pos = positions['gripper']

        # Step 1: Move to the Rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        move(env, obs['gripper_pos'], rubbish_pos)
        
        # Step 2: Pick the Rubbish
        print("[Task] Picking the rubbish")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, obs['gripper'])

        if done:
            print("[Task] Task ended after picking rubbish!")
            return
        
        # Step 3: Move to the Bottom Drawer
        print("[Task] Moving to the bottom drawer at:", bottom_drawer_pos)
        move(env, rubbish_pos, bottom_drawer_pos)
        
        # Step 4: Open the Bottom Drawer
        print("[Task] Opening the bottom drawer")
        # The action of pulling the drawer is based on holding the drawer handle
        obs, reward, done = pull(env, 'bottom_drawer', bottom_drawer_pos)
        
        if done:
            print("[Task] Task ended after opening the bottom drawer!")
            return

        # Step 5: Place the Rubbish in the Bottom Drawer
        print("[Task] Placing the rubbish in the bottom drawer")
        obs, reward, done = place(env, 'rubbish', bottom_drawer_pos)

        if done:
            print("[Task] Task ended after placing rubbish!")
            return
        
        # Step 6: Move to the Bin
        print("[Task] Moving to the bin at:", bin_pos)
        move(env, bottom_drawer_pos, bin_pos)

        # Step 7: Complete Task (if necessary, e.g., close drawer or other actions)
        # Here we can clear other actions as needed.
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()