def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Extract specific object positions
        bottom_anchor_pos = positions['bottom_anchor_pos']
        middle_side_pos = positions['middle_side_pos']
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']

        # Step 1: Move to the drawer's bottom position
        print("[Task] Moving to bottom drawer")
        obs, reward, done = move(env, 'current_room', bottom_anchor_pos)
        if done: return

        # Step 2: Open the bottom drawer
        print("[Task] Opening bottom drawer")
        obs, reward, done = pick(obj=drawer, loc=bottom_anchor_pos)
        if done: return

        # Step 3: Pull the drawer to open it
        print("[Task] Pulling the drawer")
        obs, reward, done = pull(env, 'gripper', 'bottom_drawer', bottom_anchor_pos)
        if done: return
        
        # Step 4: Move to the rubbish
        print("[Task] Moving to rubbish")
        obs, reward, done = move(env, 'current_room', rubbish_pos)
        if done: return

        # Step 5: Pick up the rubbish
        print("[Task] Picking up rubbish")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos)
        if done: return

        # Step 6: Move to the bin
        print("[Task] Moving to the bin")
        obs, reward, done = move(env, 'current_room', bin_pos)
        if done: return

        # Step 7: Place the rubbish in the bin
        print("[Task] Placing rubbish in bin")
        obs, reward, done = place(env, 'rubbish', bin_pos)
        if done: return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()