def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example positions, adjust them based on actual object names from the problem
        bottom_anchor_pos = positions['bottom_anchor_pos']
        bottom_side_pos = positions['bottom_side_pos']
        rubbish_pos = positions['rubbish']
        trash_can_pos = positions['trash_can']

        # Move to the side position of the bottom drawer
        print("[Task] Moving to the side position of the bottom drawer:", bottom_side_pos)
        obs, reward, done = move(env, task, 'start_position', bottom_side_pos)
        if done:
            print("[Task] Task ended after moving to the side position!")
            return
        
        # Pick the bottom drawer
        print("[Task] Picking the bottom drawer")
        obs, reward, done = pick(env, 'bottom_drawer', bottom_side_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer!")
            return
        
        # Open the bottom drawer
        print("[Task] Pulling and opening the bottom drawer")
        obs, reward, done = pull(env, 'gripper', 'bottom_drawer')
        if done:
            print("[Task] Task ended after opening the drawer!")
            return
        
        # Move to the rubbish to pick it up
        print("[Task] Moving to the rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, bottom_side_pos, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to the rubbish!")
            return
        
        # Pick the rubbish
        print("[Task] Picking up the rubbish")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos)
        if done:
            print("[Task] Task ended after picking the rubbish!")
            return
        
        # Move to the trash can to place the rubbish
        print("[Task] Moving to trash can at:", trash_can_pos)
        obs, reward, done = move(env, task, rubbish_pos, trash_can_pos)
        if done:
            print("[Task] Task ended after moving to the trash can!")
            return
        
        # Place the rubbish in the trash can
        print("[Task] Placing rubbish in the trash can")
        obs, reward, done = place(env, 'rubbish', trash_can_pos)
        if done:
            print("[Task] Task ended after placing the rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()