def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Extracting positions for objects we are interested in
        bin_pos = positions['bin']
        rubbish_pos = positions['rubbish']
        drawer_pos = positions['drawer']

        # Step 1: Move to the drawer to pull it
        print("[Task] Moving to drawer at:", drawer_pos)
        obs, reward, done = move(env, 'robot', obs['robot_position'], drawer_pos)
        if done:
            print("[Task] Task ended while moving to drawer!")
            return
        
        # Step 2: Open the drawer
        print("[Task] Pulling the drawer")
        obs, reward, done = pull(env, 'robot', 'drawer', 'x', pull_distance=0.5)
        if done:
            print("[Task] Task ended while pulling the drawer!")
            return

        # Step 3: Move to the rubbish to pick it up
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, 'robot', obs['robot_position'], rubbish_pos)
        if done:
            print("[Task] Task ended while moving to rubbish!")
            return

        # Step 4: Pick up the rubbish
        print("[Task] Picking up rubbish")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, 'gripper')
        if done:
            print("[Task] Task ended while picking up rubbish!")
            return

        # Step 5: Move to the bin to dispose of the rubbish
        print("[Task] Moving to bin at:", bin_pos)
        obs, reward, done = move(env, 'robot', obs['robot_position'], bin_pos)
        if done:
            print("[Task] Task ended while moving to bin!")
            return

        # Step 6: Place the rubbish into the bin
        print("[Task] Placing rubbish into bin")
        obs, reward, done = place(env, 'rubbish', bin_pos)
        if done:
            print("[Task] Task ended while placing rubbish!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()