def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Example object names based on assumptions
        object_names = ['trash', 'drawer']
        gripper = 'gripper'
        drawer = 'drawer'
        
        trash_pos = positions['trash']
        drawer_pos = positions['drawer']
        side_pos = positions['bottom_side_pos']
        anchor_pos = positions['bottom_anchor_pos']

        # 1. Move to the drawer's side position
        print(f"[Task] Moving to the side position of {drawer}.")
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], side_pos)
        
        # 2. Pick the drawer
        print(f"[Task] Picking the {drawer}.")
        obs, reward, done = pick(env, drawer, side_pos, gripper)

        # 3. Open the drawer
        print(f"[Task] Opening the {drawer}.")
        obs, reward, done = pull(env, drawer)

        # 4. Move to the trash
        print(f"[Task] Moving to the trash position.")
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], trash_pos)

        # 5. Pick the trash
        print(f"[Task] Picking the trash.")
        obs, reward, done = pick(env, 'trash', trash_pos)

        # 6. Place the trash (into the disposal area)
        print(f"[Task] Placing the trash.")
        obs, reward, done = place(env, 'trash', positions['disposal_area'])

        print("[Task] Task completed successfully!")
    
    except Exception as e:
        print(f"[Error] An exception occurred: {e}")
    
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()