def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Extract specific object positions
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        bottom_drawer_pos = positions['bottom_drawer_pos']
        top_anchor_pos = positions['top_anchor_pos']

        # === Task Execution ===
        # Move gripper to the bottom drawer position
        print("[Task] Moving to the bottom drawer position:", bottom_drawer_pos)
        obs, reward, done = move(env, task, target_pos=bottom_drawer_pos)

        if done:
            print("[Task] Task ended while moving to bottom drawer!")
            return
        
        # Pick the drawer using the pick-drawer action
        print("[Task] Picking the drawer located at:", bottom_drawer_pos)
        obs, reward, done = pick(env, obj='drawer', room=bottom_drawer_pos, gripper='gripper')

        if done:
            print("[Task] Task ended while picking the drawer!")
            return
        
        # Open the drawer
        print("[Task] Pulling the drawer to open it.")
        obs, reward, done = pull(env, obj='drawer', location=bottom_drawer_pos)

        if done:
            print("[Task] Task ended while pulling the drawer!")
            return
        
        # Pick the rubbish and then place it in the bin
        print("[Task] Picking up rubbish located at:", rubbish_pos)
        obs, reward, done = pick(env, obj='rubbish', room=rubbish_pos, gripper='gripper')

        if done:
            print("[Task] Task ended while picking the rubbish!")
            return
        
        print("[Task] Moving to the bin location:", bin_pos)
        obs, reward, done = move(env, task, target_pos=bin_pos)

        if done:
            print("[Task] Task ended while moving to bin!")
            return
        
        print("[Task] Placing rubbish in the bin.")
        obs, reward, done = place(env, obj='rubbish', room=bin_pos)

        if done:
            print("[Task] Task ended after placing rubbish!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()