def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Retrieve specific positions for drawer and rubbish
        drawer_position = positions['drawer']
        rubbish_position = positions['rubbish']
        bin_position = positions['bin']

        # PLAN TO COMPLETE: 
        # 1. Move to the drawer
        # 2. Pull the drawer open
        # 3. Pick up rubbish
        # 4. Move to the bin
        # 5. Drop the rubbish in the bin

        # Step 1: Move to the drawer
        print("[Task] Moving to drawer at:", drawer_position)
        obs, reward, done = move(env, task, from_room=obs.robot_pose[:3], to_room=drawer_position)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        # Step 2: Pull the drawer open
        print("[Task] Attempting to pull the drawer.")
        obs, reward, done = pull(env, task, pull_distance=0.1)  # Adjust distance as necessary
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 3: Pick up rubbish
        print("[Task] Picking up rubbish at:", rubbish_position)
        obs, reward, done = pick(env, obj='rubbish', room='drawer')
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return
        
        # Step 4: Move to the bin
        print("[Task] Moving to bin at:", bin_position)
        obs, reward, done = move(env, task, from_room=drawer_position, to_room=bin_position)
        if done:
            print("[Task] Task ended after moving to bin!")
            return

        # Step 5: Drop the rubbish in the bin
        print("[Task] Placing rubbish in the bin.")
        obs, reward, done = place(env, obj='rubbish', loc=bin_position)
        if done:
            print("[Task] Task completed successfully!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")