def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Initial positions
        rubbish_pos = positions['rubbish']
        drawer_pos = positions['drawer']
        gripper = "gripper"  # The default gripper object
        
        # Move to the rubbish position
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, "initial_room", rubbish_pos)
        if done:
            print("[Task] Task ended during moving to rubbish!")
            return
        
        # Pick the rubbish
        print("[Task] Picking rubbish.")
        obs, reward, done = pick(env, "rubbish", rubbish_pos, gripper)
        if done:
            print("[Task] Task ended after picking rubbish!")
            return
        
        # Move to the drawer position
        print("[Task] Moving to drawer at:", drawer_pos)
        obs, reward, done = move(env, rubbish_pos, drawer_pos)
        if done:
            print("[Task] Task ended during moving to drawer!")
            return
        
        # Place the rubbish in the drawer
        print("[Task] Placing rubbish in drawer.")
        obs, reward, done = place(env, "rubbish", drawer_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()