def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on retrieved data
        bottom_drawer_pos = positions['bottom_drawer_pos']
        middle_drawer_pos = positions['middle_drawer_pos']
        top_drawer_pos = positions['top_drawer_pos']
        rubbish_pos = positions['rubbish_pos']  # position of rubbish like papers, etc.

        # Execute plan to open drawers and dispose of rubbish
        # Step 1: Move to the bottom drawer's side position and pick it
        print("[Task] Moving to bottom drawer's side position.")
        obs = move(env, 'starting_room', 'bottom_side_pos')  # need to check the actual room names
        
        print("[Task] Picking the bottom drawer.")
        obs = pick(env, 'bottom_drawer', bottom_drawer_pos, 'gripper')
        
        print("[Task] Pulling the bottom drawer open.")
        obs = pull(env, 'bottom_drawer', bottom_drawer_pos)
        
        # Step 2: Check for rubbish in the drawer and pick it if found
        if obs.contains_rubbish:  # assuming there's a way to check if there's rubbish
            print("[Task] Picking up rubbish from the drawer.")
            obs = pick(env, 'rubbish', bottom_drawer_pos, 'gripper')
        
        # Step 3: Place the rubbish in the disposal area (update according to the exact position)
        print("[Task] Placing rubbish in the disposal area.")
        obs = place(env, 'rubbish', 'disposal_area_pos')

        # Step 4: Repeat for the middle drawer
        print("[Task] Moving to middle drawer's side position.")
        obs = move(env, 'starting_room', 'middle_side_pos')  # need to confirm position

        print("[Task] Picking the middle drawer.")
        obs = pick(env, 'middle_drawer', middle_drawer_pos, 'gripper')

        print("[Task] Pulling the middle drawer open.")
        obs = pull(env, 'middle_drawer', middle_drawer_pos)

        if obs.contains_rubbish: 
            print("[Task] Picking up rubbish from the middle drawer.")
            obs = pick(env, 'rubbish', middle_drawer_pos, 'gripper')

        print("[Task] Placing rubbish in the disposal area.")
        obs = place(env, 'rubbish', 'disposal_area_pos')

        # Step 5: Repeat for the top drawer
        print("[Task] Moving to top drawer's side position.")
        obs = move(env, 'starting_room', 'top_side_pos')  # need to check the actual room names

        print("[Task] Picking the top drawer.")
        obs = pick(env, 'top_drawer', top_drawer_pos, 'gripper')

        print("[Task] Pulling the top drawer open.")
        obs = pull(env, 'top_drawer', top_drawer_pos)

        if obs.contains_rubbish: 
            print("[Task] Picking up rubbish from the top drawer.")
            obs = pick(env, 'rubbish', top_drawer_pos, 'gripper')

        print("[Task] Placing rubbish in the disposal area.")
        obs = place(env, 'rubbish', 'disposal_area_pos')

    finally:
        # Always ensure the environment is properly shut down
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()